***** Is Europe an optimal Political Area?                *****
***** Alberto Alesina, Guido Tabellini & Francesco Trebbi *****

***** Section II.B

*Set up 
clear all
set mem 10g
set matsize 11000
set more off

* Set output directory
cap mkdir "section2"
cap mkdir "appendix"
cap mkdir "appendix/table_A5"

use "data/EVS_GSS_final.dta", clear


** EU countries excluding Eastern Europe, no Germany split - We exclude US from this analysis as we want to compute distances only for EU countries
keep if country=="AT"| country=="BE"| country=="DE"| country=="DK"| country=="ES"| country=="FI"| country=="FR"| country=="GR"| country=="IE"| country=="IT"| country=="LU"| country=="NL"| country=="NO"| country=="PT"| country=="SE"| country=="GB-GBN"
replace country="GB" if country=="GB-GBN"

** Tab some covariates to use
qui tab marital_status, gen(X_marital_status)
qui tab education, gen(X_education)
qui tab employment, gen(X_employment)
qui tab income_recoded, gen(X_income_recoded)
qui tab size_of_town, gen(X_size_of_town)
qui tab education1, gen(X_education_v)
 
** Setting waves
gen     wave = year
replace wave = 1981 if wave == 1982
replace wave = 1999 if wave == 2000
replace wave = 2008 if wave == 2009

** Standardize all variables for equal weighting in distance measures below
foreach var of varlist Y_* {
	qui sum `var'
	replace `var' = (`var'-r(mean))/r(sd)
	qui reg `var' X_*
	predict res_`var', resid
}

save tmp.dta, replace


*** Cultural Capital
use tmp.dta, clear
global vars "Y_control Y_obedience Y_trust Y_hardwork"
keep persno country country_string wave $vars 
factor $vars , pcf factor(1) 
rotate, varimax
predict i_factor

* Table A.5
mkcorr i_factor $vars, log(appendix/table_A5/culture.xls) sig replace
***

collapse (mean) mvar = i_factor, by(country country_string wave)
bysort wave: egen zero = mean(mvar) 
gen one = 1
lab var mvar "Cultural Capital"
lab var zero "0"
lab var wave "EVS Wave"

* Figure A.4a
twoway (lfit mvar wave) (scatter mvar wave, lp("-")),legend(off) /*
*/ title("Cultural Capital") subtitle("First Principal Component")
graph export "appendix/figure_A4a.png", replace 
***

* Figure A.5 
twoway (line mvar wave) (line zero wave, lp("-")) ,by(country_string, iyl legend(off)  /*
*/ title("Cultural Capital") subtitle("First Principal Component - Average by Country")/*
*/ note("Note: EVS. control, obedience, trust, hardwork. EU mean in dash.", size(vsmall)))
graph export "appendix/figure_A5.png", replace 
***
 

** Religiosity
use tmp.dta, clear
global vars "Y_god Y_religious Y_euthan Y_suicide"
keep persno country country_string wave $vars 
factor $vars , pcf factor(1) 
rotate, varimax
predict i_factor

* Table A.5
mkcorr i_factor $vars, log(appendix/table_A5/religiosity.xls) sig replace
***

collapse (mean) mvar = i_factor, by(country_string country wave)
bysort wave: egen zero = mean(mvar)
gen one = 1
lab var mvar "Religiosity"
lab var zero "0"
lab var wave "EVS Wave"

* Figure A.4b 
twoway (lfit mvar wave) /*
*/      (scatter mvar wave, lp("-")),legend(off) /*
*/ title("Religiosity") subtitle("First Principal Component")
graph export "appendix/figure_A4b.png", replace 
***

* figure A.6
twoway (line mvar wave) (line zero wave, lp("-")),by(country_string, iyl legend(off) /*
*/ title("Religiosity") subtitle("First Principal Component - Average by Country")/*
*/ note("Note: EVS. Importance of God, Is Religious, Euthanasia, Suicide. EU mean in dash.", size(vsmall)))
graph export "appendix/figure_A6.png", replace  
***


** Sexual Morality
use tmp.dta, clear
global vars "Y_abortion Y_divorce Y_gay"
factor Y_abortion Y_divorce Y_gay , pcf factor(1) 
rotate, varimax
predict i_factor

* Table A.5
mkcorr i_factor $vars, log(appendix/table_A5/sexual_morality.xls) sig replace
***

collapse (mean) mvar = i_factor, by(country_string country wave)
bysort wave: egen zero = mean(mvar)
gen one = 1
lab var mvar "Morality"
lab var zero "0"
lab var wave "Wave"

* Figure A.4c
twoway (lfit mvar wave) (scatter mvar wave, lp("-")),legend(off) /*
*/ title("Sexual Morality") subtitle("First Principal Component")
graph export "appendix/figure_A4c.png", replace 
***

* Figure A.7
twoway (line mvar wave) (line zero wave, lp("-")),by(country_string, iyl legend(off) /*
*/ title("Sexual Morality") subtitle("First Principal Component - Average by Country")/*
*/ note("Note: EVS. Abortion, Divorce, Homosexuality. EU mean in dash.", size(vsmall)))
graph export "appendix/figure_A7.png", replace 
***


** Gender Equality
use tmp.dta, clear
global vars "Y_workingfemale Y_preschoolm Y_careerfemale"
keep persno country country_string wave $vars 
factor $vars , pcf factor(1) 
rotate, varimax
predict i_factor

* Table A.5
mkcorr i_factor $vars, log(appendix/table_A5/gender_equality.xls) sig replace
***

collapse (mean) mvar = i_factor, by(country_string country wave)
bysort wave: egen zero = mean(mvar)
gen one = 1
lab var mvar "Gender Roles"
lab var zero "0"
lab var wave "EVS Wave"

* Figure A.4d
twoway (lfit mvar wave) (scatter mvar wave, lp("-")),legend(off) /*
*/ title("Gender Equality") subtitle("First Principal Component")
graph export "appendix/figure_A4d.png", replace 
***

* Figure A.8
twoway (line mvar wave) (line zero wave, lp("-")),by(country_string, iyl legend(off) /*
*/ title("Gender Equality") subtitle("First Principal Component - Average by Country")/*
*/ note("Note: EVS. Working female, Pre-school mom, Career female. EU mean in dash.", size(vsmall)))
graph export "appendix/figure_A8.png", replace 
***


** Role of the state
use tmp.dta, clear
global vars "Y_equalize Y_private Y_redistrib Y_ideology"
keep persno country country_string wave $vars 
factor $vars , pcf factor(1) 
rotate, varimax
predict i_factor

* Table A.5
mkcorr i_factor $vars, log(appendix/table_A5/role_state.xls) sig replace
***

collapse (mean) mvar = i_factor (sd) sdvar = i_factor, by(country_string country wave)
bysort wave: egen zero = mean(mvar)
gen one = 1
lab var mvar "Free-Market Economics"
lab var zero "0"
lab var wave "EVS Wave"

* Figure A.4e
twoway (lfit mvar wave) (scatter mvar wave, lp("-")),legend(off) /*
*/ title("Role of the State") subtitle("First Principal Component")
graph export "appendix/figure_A4e.png", replace 
***

* Figure A9
twoway (line mvar wave) (line zero wave, lp("-")),by(country_string, iyl legend(off) /*
*/ title("Role of the State") subtitle("First Principal Component - Average by Country")/*
*/ note("Note: EVS. Individual effort, Private property, No state responsibility for redistribution," "Conservative Ideology. EU mean in dash.", size(vsmall)))
graph export "appendix/figure_A9.png", replace 
***

****
erase tmp.dta

